#include "commonheaders.h"
#include "cls-window.h"
#include "cls-window-drawing.h"

Label::Label(short xLocation, short yLocation, char *text) {
    xPos = xLocation;
    yPos = yLocation;
    label = (char *)calloc(strlen(text)+1, sizeof(char));
    strcpy(label, text);
    label[strlen(text)+1] = '\0';

    image = NULL;
}
Label::Label(short xLocation, short yLocation, BITMAP *mainImage) {
    xPos = xLocation;
    yPos = yLocation;
    image = mainImage;
    
    label = NULL;
}
void Label::SetText(char *text) {
    label = (char *)calloc(strlen(text)+1, sizeof(char));
    strcpy(label, text);
    label[strlen(text)+1] = '\0';
}
void Label::SetImage(BITMAP *mainImage) {
    image = mainImage;
}
void Label::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(label != NULL) {
        textprintf(output, font, xPos + xLocation + 1, yPos + yLocation + 1, BLACK, label);
        textprintf(output, font, xPos + xLocation, yPos + yLocation, WHITE, label);
    } else {
        draw_sprite(output, image, xPos + xLocation, yPos + yLocation);
    }
}

Button::Button(short xLocation, short yLocation, short winWidth, short winHeight, char *text, void (*funct)(void)) {
    label = (char *)calloc(strlen(text)+1, sizeof(char));
    strcpy(label, text);
    label[strlen(text)+1] = '\0';
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    height = winHeight;
    pressed = false;
    press = funct;
    
    image = NULL;
    pressimage = NULL;
}

Button::Button(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, void (*funct)(void)) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    image = mainImage;
    height = winHeight;
    pressed = false;
    press = funct;
    
    label = NULL;
    pressimage = NULL;
}

Button::Button(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, BITMAP *switchimage, void (*funct)(void)) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    image = mainImage;
    height = winHeight;
    pressimage = switchimage;
    pressed = false;
    press = funct;
    
    label = NULL;
}
bool Button::Check(short xLocation, short yLocation) {
    if(mouse_inarea(xPos + xLocation, yPos + yLocation, width, height)) {
        if(mouse_b & 1) {
            pressed = true;
        } else {
            if(pressed) {
                press();
                pressed = false;
            }
        }
    } else {
        if(pressed) pressed = false;  
    }
    return false;
}
void Button::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(image == NULL) {
        button(output, xPos + xLocation, yPos + yLocation, width, height, makecol(96, 96, 96), pressed, NULL, label);
    } else {
        if(pressed && pressimage != NULL) {
            button(output, xPos + xLocation, yPos + yLocation, width, height, makecol(96, 96, 96), pressed, pressimage, NULL);
        } else {
            button(output, xPos + xLocation, yPos + yLocation, width, height, makecol(96, 96, 96), pressed, image, NULL);
        }
    }
}

Selector::Selector(short xLocation, short yLocation, short winWidth, short winHeight, char *text, short *refval, short triggerval) {
    label = (char *)calloc(strlen(text)+1, sizeof(char));
    strcpy(label, text);
    label[strlen(text)+1] = '\0';
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    height = winHeight;
    ref = refval;
    trig = triggerval;
    
    image = NULL;
    highlight = create_bitmap(width, height);
    clear_to_color(highlight, makecol(192,192,192));
}
Selector::Selector(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, short *refval, short triggerval) {
    image = mainImage;
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    height = winHeight;
    ref = refval;
    trig = triggerval;
    
    label = NULL;
    highlight = create_bitmap(width, height);
    clear_to_color(highlight, makecol(192,192,192));
}
bool Selector::SetImage(BITMAP *newImage) {
    if(image == NULL) {
        free(label);
        label = NULL;
    }
    image = newImage;
}
bool Selector::SetText(char *newString) {
    if(label == NULL) {
        image = NULL;
        label[strlen(newString)+1] = '\0';
    } else {
        free(label);
        label = (char *)realloc(label, sizeof(char) * (strlen(newString)+1));
    }
    strcpy(label, newString);
}
bool Selector::Check(short xLocation, short yLocation) {
    if(mouse_inarea(xPos + xLocation, yPos + yLocation, width, height)) {
        if(mouse_b & 1) {
            if(ref != NULL) {
                *ref = trig;
            }
        }
    }
    return false;
}
void Selector::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(image == NULL) {
        selector(output, xPos + xLocation, yPos + yLocation, width, height, NULL, label);
    } else {
        selector(output, xPos + xLocation, yPos + yLocation, width, height, image, NULL);
    }
    set_trans_blender(0, 0, 0, 128);
    if(*ref == trig) {
        draw_trans_sprite(output, highlight, xPos + xLocation, yPos + yLocation);
    }
}

ScrollBox::ScrollBox(short xLocation, short yLocation, short winWidth, bool dropdown, short *refval, short lowval, short highval, short increment) {
    refmode = 0;
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    ref = refval;
    
    low = lowval;
    high = highval;
    inc = increment;
    drop = dropdown;
    right = false;
    left = false;
    droppress = false;
    input = (char *)calloc((width / 8), sizeof(char));
    waitingforinput = false;
}
ScrollBox::ScrollBox(short xLocation, short yLocation, short winWidth, bool dropdown, short *refval, char **stringarray, short strlength) {
    short i = 0;
    refmode = 1;
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    ref = refval;
    optList = stringarray;
    
    low = 0;
    while(i < 200 && optList[i] != NULL) {
        printf("%s,%i:%s\n", optList[i], &DogList[i], DogList[i]);
        i ++;
    }
    high = i - 1;
    inc = 1;
    drop = dropdown;
    right = false;
    left = false;
    droppress = false;
    input = (char *)calloc((width / 8), sizeof(char));
    waitingforinput = false;
}

bool ScrollBox::Check(short xLocation, short yLocation) {
    bool ret = false;
    if(waitingforinput) {
        short inval;
        ret = true;
        if(strlen(input) < (width / 8) - 1) {
            GetInputFromBuffer(input, strlen(input), refmode);
        } else {
            GetInputFromBuffer(input, strlen(input) - 1, refmode);
        }
        inval = atoi(input);
        if(inval < low) {
            *ref = low;
        } else if(inval > high) {
            *ref = high;
        } else {
            *ref = inval;
        }
        if((mouse_b & 1) || (mouse_b & 2)) {
            waitingforinput = false;
        }
    }
    if(mouse_inarea(xPos + xLocation, yPos + yLocation, 8, 16)) {
        if(mouse_b & 1 && !left) {
            left = true;
            right = false;
            droppress = false;
            if(inc > 0 && ref != NULL) {
                if(*ref > low) {
                    *ref -= inc;
                } else if(*ref == low) {
                    *ref = high;
                }
                if(*ref < low) *ref = low;
            }
        }
    } else if(mouse_inarea(xPos + xLocation + width + 8, yPos + yLocation, 8, 16)) {
        if(mouse_b & 1 && !right) {
            right = true;
            left = false;
            droppress = false;
            if(inc > 0 && ref != NULL) {
                if(*ref < high) {
                    *ref += inc;
                } else if(*ref == high) {
                    *ref = low;
                }
                if(*ref > high) *ref = high;
            }
        }
    } else if(mouse_inarea(xPos + xLocation + 8, yPos + yLocation, width, 16)) {
        if(mouse_b & 1) {
            droppress = false;
            if(!waitingforinput) {
                strclr(input);
                if(*ref > 0) {
                    itoa(*ref, input,10);
                }
                waitingforinput = true;
            }
        }
    } else if(drop) {
        if(mouse_inarea(xPos + xLocation + width + 16, yPos + yLocation, 16, 16)) {
            if(mouse_b & 1) {
                droppress = true;
                right = false;
                left = false;
            }
        }
    } else {
        left = false;
        right = false;
        droppress = false;
    }
    if(droppress) {
        if(mouse_b & 1) {
            if(yPos + yLocation + 144 <= WIN_HEIGHT) {
                if(!mouse_inarea(xPos + xLocation, yPos + yLocation, width + 32, 144)) {
                    droppress = false;
                }
            } else {
                if(!mouse_inarea(xPos + xLocation, yPos + yLocation - 128, width + 32, 144)) {
                    droppress = false;
                }
            }
        }
    }
    if(!(mouse_b & 1)) {
        left = false;
        right = false;
    }
    if(curflash < 90) {
        curflash ++;
    } else {
        curflash = 0;
    }
    return ret;
}
void ScrollBox::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(!left) {
        draw_sprite(output, ScrollArrow, xPos + xLocation, yPos + yLocation);
    } else {
        draw_sprite(output, ScrollArrowPush, xPos + xLocation, yPos + yLocation);
    }
    text_box(output, xPos + xLocation + 8, yPos + yLocation, width, 16, makecol(64,64,64), NULL);
    if(inc > 0 && ref != NULL && !waitingforinput) {
        if(refmode == 0) {
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%i", *ref);
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "%i", *ref);
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%i", *ref); 
        } else {
            if(*ref >= low && *ref <= high) {
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%s", optList[*ref]);
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "%s", optList[*ref]);
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%s", optList[*ref]); 
            }
        }
    }
    if(waitingforinput) {
        if(input[0] == '\0') {
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "0");
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "0");
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "0"); 
            if(curflash < 45) {
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "_");
                textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "_"); 
            }
        } else {
            char addon = '\0';
            if(strlen(input) < (width / 8) - 1) {
                if(curflash < 45) {
                    addon = '_';
                } else {
                    addon = ' ';
                }
            }
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%s%c", input, addon);
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3,  makecol(32, 32, 32), "%s%c", input, addon);
            textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%s%c", input, addon); 
            if(addon != '_' && curflash < 45) {
                textprintf(output, font, xPos + xLocation + 4 + (width / 2) + (strlen(input) - 1) * 8 / 2 + 1, yPos + yLocation + 8 - 3,  makecol(32, 32, 32), "_");
                textprintf(output, font, xPos + xLocation + 4 + (width / 2) + (strlen(input) - 1) * 8 / 2, yPos + yLocation + 8 - 4, makecol(255, 255, 255), "_"); 
            }
        }
                
    }
    if(!right) {
        draw_sprite_h_flip(output, ScrollArrow, xPos + xLocation + width + 8, yPos + yLocation);
    } else {
        draw_sprite_h_flip(output, ScrollArrowPush, xPos + xLocation + width + 8, yPos + yLocation);
    }
    if(drop) {
        draw_sprite(output, ScrollDown, xPos + xLocation + width + 16, yPos + yLocation);
        if(droppress) {
            if(yPos + yLocation + 144 <= WIN_HEIGHT) {
                text_box(output, xPos + xLocation, yPos + yLocation + 16, width + 32, 128, makecol(64,64,64), NULL);
            } else {
                text_box(output, xPos + xLocation, yPos + yLocation - 128, width + 32, 128, makecol(64,64,64), NULL);
            }
        }
    }
}

TextBox::TextBox(short xLocation, short yLocation, short winWidth, char **stringarray) {
    short i = 0;
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    ref = stringarray;
    input  = (char *)calloc((width / 8), sizeof(char));
    *ref = (char *)calloc((width / 8), sizeof(char));
    waitingforinput = false;
}
bool TextBox::Check(short xLocation, short yLocation) {
    bool ret = false;
    if(waitingforinput) {
        ret = true;
        if(strlen(input) < (width / 8) - 1) {
            GetInputFromBuffer(input, strlen(input), 1);
        } else {
            GetInputFromBuffer(input, strlen(input) - 1, 1);
        }
        if((mouse_b & 1) || (mouse_b & 2)) {
            strcpy(*ref, input);
            waitingforinput = false;
        }
    }
    if(mouse_inarea(xPos + xLocation, yPos + yLocation, width, 16)) {
        if(mouse_b & 1) {
            if(!waitingforinput) {
                strclr(*ref);
                strclr(input);
                waitingforinput = true;
            }
        }
    }     
    if(curflash < 90) {
        curflash ++;
    } else {
        curflash = 0;
    }
    return ret;;
}
void TextBox::Draw(BITMAP *output, short xLocation, short yLocation) {
    text_box(output, xPos + xLocation, yPos + yLocation, width, 16, makecol(64,64,64), NULL);
    if(ref != NULL && !waitingforinput) {
        textprintf_centre(output, font, xPos + xLocation + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%s", *ref);
        textprintf_centre(output, font, xPos + xLocation + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "%s", *ref);
        textprintf_centre(output, font, xPos + xLocation + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%s", *ref); 
    }
    if(waitingforinput) {
        if(input[0] == '\0') {
            //textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "");
            //textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "");
            //textprintf_centre(output, font, xPos + xLocation + 8 + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), ""); 
            if(curflash < 45) {
                textprintf_centre(output, font, xPos + xLocation + (width / 2) + 1, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "_");
                textprintf_centre(output, font, xPos + xLocation + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "_"); 
            }
        } else {
            char addon = '\0';
            if(strlen(input) < (width / 8) - 1) {
                if(curflash < 45) {
                    addon = '_';
                } else {
                    addon = ' ';
                }
            }
            textprintf_centre(output, font, xPos + xLocation + (width / 2) + 2, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%s%c", input, addon);
            textprintf_centre(output, font, xPos + xLocation + (width / 2) + 1, yPos + yLocation + 8 - 3,  makecol(32, 32, 32), "%s%c", input, addon);
            textprintf_centre(output, font, xPos + xLocation + (width / 2), yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%s%c", input, addon); 
            if(addon != '_' && curflash < 45) {
                textprintf(output, font, xPos + xLocation - 4 + (width / 2) + (strlen(input) - 1) * 8 / 2 + 1, yPos + yLocation + 8 - 3,  makecol(32, 32, 32), "_");
                textprintf(output, font, xPos + xLocation - 4 + (width / 2) + (strlen(input) - 1) * 8 / 2, yPos + yLocation + 8 - 4, makecol(255, 255, 255), "_"); 
            }
        }
    };
}

Scroller::Scroller(short xLocation, short yLocation, short winWidth, short *refval, short lowval, short highval, short increment, bool marked) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    ref = refval;
    ticks = marked;
    left = false;
    right = false;
    barclick = false;
    
    low = lowval;
    high = highval;
    inc = increment;
    spacing = (width - 34);
    spacing /= (((high - low) / inc));
}
bool Scroller::Check(short xLocation, short yLocation) {
    if(mouse_inarea(xPos + 1 + xLocation, yPos + 1 + yLocation, 9, 10)) {
        if(mouse_b & 1 && !left) {
            left = true;
            right = false;
            if(*ref > low) *ref -= inc;
            if(*ref < low) *ref = low;
        }
    } else if (mouse_inarea(xPos + width - 11 + xLocation, yPos + 1 + yLocation, 9, 10)) {
        if(mouse_b & 1 && !right) {
            right = true;
            left = false;
            if(*ref < high) *ref += inc;
            if(*ref > high) *ref = high;
        }
    } else if(mouse_inarea(xPos + 14 + xLocation, yPos - 2 + yLocation, width - 28, 15)) {
        if(mouse_b & 1 && !barclick) {
            for(short i = 0; i <= ((high - low) / inc); i ++) {
                if(mouse_inarea(xPos + xLocation + (int)(i * spacing) - (int)(spacing / 2) + 16, yPos - 2 + yLocation, (int)(spacing) + 1, 15)) {
                    *ref = i * inc + low;
                }
            }
            right = false;
            left = false;
        }
    } else {
        left = false;
        right = false;
        barclick = false;
    }
    if(!(mouse_b & 1)) {
        left = false;
        right = false;
        barclick = false;
    }
    return false;
}
void Scroller::Draw(BITMAP *output, short xLocation, short yLocation) {
    
    if(!left) {
        draw_sprite(output, SliderEnd, xPos + xLocation, yPos + yLocation);
    } else {
        draw_sprite(output, SliderPush, xPos + xLocation, yPos + yLocation);
    }
    line(output, xPos + 15 + xLocation, yPos + 2 + yLocation, xPos + width - 16 + xLocation, yPos + 2 + yLocation, makecol(0,0,0));
    line(output, xPos + 15 + xLocation, yPos + 3 + yLocation, xPos + width - 16 + xLocation, yPos + 3 + yLocation, makecol(128,128,128));
    line(output, xPos + 15 + xLocation, yPos + 4 + yLocation, xPos + width - 16 + xLocation, yPos + 4 + yLocation, makecol(64,64,64));
    line(output, xPos + 15 + xLocation, yPos + 5 + yLocation, xPos + width - 16 + xLocation, yPos + 5 + yLocation, makecol(96,96,96));
    line(output, xPos + 15 + xLocation, yPos + 6 + yLocation, xPos + width - 16 + xLocation, yPos + 6 + yLocation, makecol(128,128,128));
    line(output, xPos + 15 + xLocation, yPos + 7 + yLocation, xPos + width - 16 + xLocation, yPos + 7 + yLocation, makecol(160,160,160));
    line(output, xPos + 15 + xLocation, yPos + 8 + yLocation, xPos + width - 16 + xLocation, yPos + 8 + yLocation, makecol(192,192,192));
    if(!right) {
        draw_sprite_h_flip(output, SliderEnd, xPos + width - 16 + xLocation, yPos + yLocation);
    } else {
        draw_sprite_h_flip(output, SliderPush, xPos + width - 16 + xLocation, yPos + yLocation);
    }
    if(ticks) {
        for(short i = 0; i <= ((high - low) / inc); i ++) {
            line(output, xPos + xLocation + 16 + (int)(i * spacing), yPos - 2 + yLocation, xPos + xLocation + 16 + (int)(i * spacing), yPos + yLocation, makecol(0,0,0));
        }
    }
    draw_sprite(output, Slider, xPos + xLocation + 14 + (int)((*ref - low) / inc * spacing), yPos + yLocation - 1);
}

Window::Window(short xLocation, short yLocation, short winWidth, short winHeight, char *title, void (*funct)(void)) {
    mobile = true;
    hides = true;
    pushhide = false;
    visible = true;
    closes = true;
    pushclose = false;
    active = true;
    xPos = xLocation;
    yPos = yLocation + 17;
    orixPos = xLocation;
    oriyPos = yLocation + 17;
    width = winWidth;
    height = winHeight;
    close = funct;
    grabX = -1;
    grabY = -1;
    label = (char *)malloc((strlen(title) + 1) * sizeof(char));
    strcpy(label, title);
    label[strlen(title)] = '\0';
    labels = 0;
    buttons = 0;
    sliders = 0;
    selectors = 0;
    scrollboxes = 0;
    textboxes = 0;
    Labels = NULL;
    Buttons = NULL;
    Sliders = NULL;
    Selectors = NULL;
    ScrollBoxes = NULL;
    TextBoxes = NULL;
    /*Buttons = (Button **)malloc(sizeof(Button *));
    Sliders = (Scroller **)malloc(sizeof(Scroller *));
    Selectors = (Selector **)malloc(sizeof(Selector *));
    ScrollBoxes = (ScrollBox **)malloc(sizeof(ScrollBox *));*/
}
bool Window::AddLabel(short xLocation, short yLocation, char *text) {
    if(Labels == NULL) 
        Labels = (Label **)malloc(sizeof(Label *) * (labels + 1));
    else 
        Labels = (Label **)realloc(Labels, sizeof(Label *) * (labels + 1));
    Labels[labels] = new Label(xLocation + 4, yLocation + 17, text);
    if(Labels[labels] == NULL) {
        return false;
    }
    labels ++;
    return true;
}
bool Window::AddLabel(short xLocation, short yLocation, BITMAP *mainImage) {
    if(Labels == NULL) 
        Labels = (Label **)malloc(sizeof(Label *) * (labels + 1));
    else 
        Labels = (Label **)realloc(Labels, sizeof(Label *) * (labels + 1));
    Labels[labels] = new Label(xLocation + 4, yLocation + 17, mainImage);
    if(Labels[labels] == NULL) {
        return false;
    }
    labels ++;
    return true;
}
bool Window::AddButton(short xLocation, short yLocation, short winWidth, short winHeight, char *text, void (*funct)(void)) {
    Buttons = (Button **)realloc(Buttons, sizeof(Button *) * (buttons + 1));
    Buttons[buttons] = new Button(xLocation + 4, yLocation + 17, winWidth, winHeight, text, funct);
    if(Buttons[buttons] == NULL) {
        return false;
    }
    buttons ++;
    return true;
}

bool Window::AddButton(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, void (*funct)(void)) {
    Buttons = (Button **)realloc(Buttons, sizeof(Button *) * (buttons + 1));
    Buttons[buttons] = new Button(xLocation + 4, yLocation + 17, winWidth, winHeight, mainImage, funct);
    if(Buttons[buttons] == NULL) {
        return false;
    }
    buttons ++;
    return true;
}

bool Window::AddButton(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, BITMAP *switchimage, void (*funct)(void)) {
    Buttons = (Button **)realloc(Buttons, sizeof(Button *) * (buttons + 1));
    Buttons[buttons] = new Button(xLocation + 4, yLocation + 17, winWidth, winHeight, mainImage, switchimage, funct);
    if(Buttons[buttons] == NULL) {
        return false;
    }
    buttons ++;
    return true;
}
bool Window::AddSelector(short xLocation, short yLocation, short winWidth, short winHeight, char *text, short *refval, short triggerval) {
    if(refval != NULL) {
        Selectors = (Selector **)realloc(Selectors, sizeof(Selector *) * (selectors + 1));
        Selectors[selectors] = new Selector(xLocation + 4, yLocation + 17, winWidth, winHeight, text, refval, triggerval);
        if(Selectors[selectors] == NULL) {
            return false;
        }
        selectors ++;
        return true;
    } else {
        return false;
    }
}
bool Window::AddSelector(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, short *refval, short triggerval) {
    if(refval != NULL) {
        Selectors = (Selector **)realloc(Selectors, sizeof(Selector *) * (selectors + 1));
        Selectors[selectors] = new Selector(xLocation + 4, yLocation + 17, winWidth, winHeight, mainImage, refval, triggerval);
        if(Selectors[selectors] == NULL) {
            return false;
        }
        selectors ++;
        return true;
    } else {
        return false;
    }
}
bool Window::AddSlider(short xLocation, short yLocation, short winWidth, short *refval, short lowval, short highval, short increment, bool marked) {
    if(refval != NULL) {
        Sliders = (Scroller **)realloc(Sliders, sizeof(Scroller *) * (sliders + 1));
        Sliders[sliders] = new Scroller(xLocation + 4, yLocation + 17, winWidth, refval, lowval, highval, increment, marked);
        if(Sliders[sliders] == NULL) {
            return false;
        }
        sliders ++;
        return true;
    } else {
        return false;
    }
}
bool Window::AddScrollBox(short xLocation, short yLocation, short winWidth, bool dropdown, short *refval, short lowval, short highval, short increment) {
    ScrollBoxes = (ScrollBox **)realloc(ScrollBoxes, sizeof(ScrollBox *) * (scrollboxes + 1));
    ScrollBoxes[scrollboxes] = new ScrollBox(xLocation + 4, yLocation + 17, winWidth, dropdown, refval, lowval, highval, increment);
    if(ScrollBoxes[scrollboxes] == NULL) {
        return false;
    }
    scrollboxes ++;
    return true;
}
bool Window::AddScrollBox(short xLocation, short yLocation, short winWidth, bool dropdown, short *refval, char **stringarray, short strlength) {
    ScrollBoxes = (ScrollBox **)realloc(ScrollBoxes, sizeof(ScrollBox *) * (scrollboxes + 1));
    ScrollBoxes[scrollboxes] = new ScrollBox(xLocation + 4, yLocation + 17, winWidth, dropdown, refval, stringarray, strlength);
    if(ScrollBoxes[scrollboxes] == NULL) {
        return false;
    }
    scrollboxes ++;
    return true;
}
bool Window::AddTextBox(short xLocation, short yLocation, short winWidth, char **stringarray) {
    TextBoxes = (TextBox **)realloc(TextBoxes, sizeof(TextBox *) * (textboxes + 1));
    TextBoxes[textboxes] = new TextBox(xLocation + 4, yLocation + 17, winWidth, stringarray);
    if(TextBoxes[textboxes] == NULL) {
        return false;
    }
    textboxes ++;
    return true;
}
void Window::Mobile(void) {
    mobile = true;
}
void Window::Immobile(void) {
    mobile = false;
}
void Window::Shades(void) {
    hides = true;
}
void Window::NoShade(void) {
    hides = false;
}
void Window::Open(void) {
    active = true;
}
void Window::Close(void) {
    active = false;
}
int Window::Check(void) {
    short retint;
    retint = -1;
    if(active) {
        for(short i = 0; i < scrollboxes; i ++) {
            if(ScrollBoxes[i]) {
                waitingforinput = ScrollBoxes[i]->Check(xPos, yPos);
            }
        }
        retint = 0;
        if(mouse_inarea(xPos, yPos, width, height) && !grab) {
            if(mouse_inarea(xPos, yPos + 17, width, height)) {
                if(visible) {
                    if(mouse_b & 1) {
                        retint = 1;
                    }
                    for(short i = 0; i < buttons; i ++) {
                        Buttons[i]->Check(xPos, yPos);
                    }
                    for(short i = 0; i < selectors; i ++) {
                        Selectors[i]->Check(xPos, yPos);
                    }
                    for(short i = 0; i < sliders; i ++) {
                        Sliders[i]->Check(xPos, yPos);
                    }
                    for(short i = 0; i < textboxes; i ++) {
                        waitingforinput = TextBoxes[i]->Check(xPos, yPos);
                    }
                    for(short i = 0; i < scrollboxes; i ++) {
                        waitingforinput = ScrollBoxes[i]->Check(xPos, yPos);
                    }
                }
            } else {
                if(mouse_b & 1) {
                    retint = 1;
                }
                if(mouse_inarea(xPos + width - 45, yPos + 2, 13, 12) && closes) {
                    if(mouse_b & 1 && !pushorigin) {
                        pushorigin = true;
                    }
                    if(!mouse_b & 1 && pushorigin) {
                        pushorigin = false;
                        xPos = orixPos;
                        yPos = oriyPos;
                    }
                } 
                if(mouse_inarea(xPos + width - 15, yPos + 2, 13, 12) && closes) {
                    if(mouse_b & 1 && !pushclose) {
                        pushclose = true;
                    }
                    if(!mouse_b & 1 && pushclose) {
                        pushclose = false;
                        active = false;
                        retint = -1;
                        close();
                    }
                } 
                if(mouse_inarea(xPos + width - 30, yPos + 2, 13, 12) && hides) {
                    if(mouse_b & 1 && !pushhide) {
                        pushhide = true;
                    }
                    if(!mouse_b & 1 && pushhide) {
                        pushhide = false;
                        if(visible) {
                            visible = false;
                        } else {
                            visible = true;
                            if(yPos + height > WIN_HEIGHT) yPos = WIN_HEIGHT - height - 1;
                        }
                    }
                } else if(mouse_b & 1 && mobile) {
                    if(!grab && !pushclose && !pushhide && !pushorigin) {
                        grabX = mouse_x - xPos;
                        grabY = mouse_y - yPos;
                        grab = true;
                    }
                } else {
                    if(pushclose) {
                        pushclose = false;
                    }
                    if(pushhide) {
                        pushhide = false;
                    }
                    if(pushorigin) {
                        pushorigin = false;
                    }
                }
            }
        }
        if(grab && mobile) {
            retint = 1;
            if(mouse_b & 1) {
                xPos = mouse_x - grabX;
                yPos = mouse_y - grabY;
                if(yPos < 17) yPos = 17;
                if(xPos < 0) xPos = 0;
                if(xPos + width > WIN_WIDTH) xPos = WIN_WIDTH - width - 1;
                if(visible) {
                    if(yPos + height > WIN_HEIGHT) yPos = WIN_HEIGHT - height - 1;
                } else {
                    if(yPos + 29 > WIN_HEIGHT) yPos = WIN_HEIGHT - 19;
                }
            } else {
                grabX = -1;
                grabY = -1;
                grab = false;
            }
        }
    }
    return(retint);
}
void Window::Draw(BITMAP *output) {
    if(active) {
        if(visible) {
            gui_window(output, xPos, yPos, width, height, makecol(80, 80, 80));
            if(closes) {
                if(pushclose && mouse_inarea(xPos + width - 15, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinClosePush, xPos + width - 15, yPos + 2);
                } else {
                    draw_sprite(output, WinClose, xPos + width - 15, yPos + 2);
                }
            }
            if(hides) {
                if(pushhide && mouse_inarea(xPos + width - 30, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinShadePush, xPos + width - 30, yPos + 2);
                } else {
                    draw_sprite(output, WinShade, xPos + width - 30, yPos + 2);
                }
            }
                if(pushorigin && mouse_inarea(xPos + width - 45, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinRestorePush, xPos + width - 45, yPos + 2);
                } else {
                    draw_sprite(output, WinRestore, xPos + width - 45, yPos + 2);
                }
            textprintf(output, font, xPos + 5, yPos + 4, BLACK, label);
            textprintf(output, font, xPos + 4, yPos + 3, WHITE, label);
            short i;
            for(i = 0; i < labels; i ++) {
                if(Labels[i]) {
                    Labels[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < buttons; i ++) {
                if(Buttons[i]) {
                    Buttons[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < selectors; i ++) {
                if(Selectors[i]) {
                    Selectors[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < sliders; i ++) {
                if(Sliders[i]) {
                    Sliders[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < scrollboxes; i ++) {
                if(ScrollBoxes[i]) {
                    printf("%i", i);
                    ScrollBoxes[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < textboxes; i ++) {
                if(TextBoxes[i]) {
                    TextBoxes[i]->Draw(output, xPos, yPos);
                }
            }
        } else {
            winshade_window(output, xPos, yPos, width, 18);
            if(closes) {
                if(pushclose && mouse_inarea(xPos + width - 15, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinClosePush, xPos + width - 15, yPos + 2);
                } else {
                    draw_sprite(output, WinClose, xPos + width - 15, yPos + 2);
                }
            }
            if(hides) {
                if(pushhide && mouse_inarea(xPos + width - 30, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinShadePush, xPos + width - 30, yPos + 2);
                } else {
                    draw_sprite(output, WinShade, xPos + width - 30, yPos + 2);
                }
            }
                if(pushorigin && mouse_inarea(xPos + width - 45, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinRestorePush, xPos + width - 45, yPos + 2);
                } else {
                    draw_sprite(output, WinRestore, xPos + width - 45, yPos + 2);
                }
            textprintf(output, font, xPos + 5, yPos + 4, BLACK, label);
            textprintf(output, font, xPos + 4, yPos + 3, WHITE, label);
        }
    }
}
